@extends('adminlayout.dashadmin')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels@2"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels@2"></script>
<style>
    #leadChart {
    max-width: 600px!important;
    margin: 20px auto!important;
}
</style>
@section('content')
<div class="content-wrapper">
<section class="content">
 <div class="row profile-heading">

      <div class="col-sm-12 col-xs-12 contact">
        <div class="box box-info">
          <div class="box-header with-border text-center">
            <h3 class="box-title">Lead Report</h3>
            <a class="btn btn-sm btn-dark" href="javascript:history.back()" style="float: inline-end;"> << Go Back</a>
          </div>
          
          @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
          @endif
           
          <div class="modal-body">
            <div class="row">
             <div class="col-sm-12 col-xs-12 contact"> 
             <div class="row">
             <div class="col-sm-4 col-xs-12"> 
              <!-- Lead Status Dropdown Filter -->
                <div class="mb-3">
                  <label for="statusFilter" class="form-label fw-bold">Filter by Lead Status:</label>
                  <select id="statusFilter" class="form-control w-50" onchange="applyFilters()">
                    <option value="all">All</option>
                    <option value="New">New</option>
                    <option value="Interested">Interested</option>
                    <option value="NotInterested">NotInterested</option>
                    <option value="Callback Later">Callback Later</option>
                    <option value="Converted">Converted</option>
                    <option value="Dropped">Dropped</option>
                  </select>
                </div>
                
                <!-- Preset Filters -->
                <div class="mb-3">
                  <label class="form-label fw-bold d-block">Quick Date Range:</label>
                  <div class="btn-group" role="group">
                    <button class="btn  btn-info  btn-lg" onclick="loadData('7d')">Last 7 Days</button>
                    <button class="btn btn-info btn-success btn-lg" onclick="loadData('1m')">1 Month</button>
                    <button class="btn btn-info btn-success btn-lg" onclick="loadData('3m')">3 Months</button>
                    <button class="btn btn-info btn-success btn-lg" onclick="loadData('6m')">6 Months</button>
                    <button class="btn btn-info btn-success btn-lg" onclick="loadData('1y')">1 Year</button>
                  </div>
                </div>
              </div>  
             <div class="col-sm-4 col-xs-12"> 
                <!-- Custom Date Range -->
                <div class="mb-3">
                  <label for="customRange" class="form-label fw-bold">Custom Date Range:</label>
                  <div class="input-group w-50">
                    <input type="text" id="customRange" class="form-control" placeholder="Select custom date range">
                    <button class="btn btn-success mb-3" onclick="loadData('custom')">Apply</button>
                  </div>
                </div>

              </div>  
             <div class="col-sm-4 col-xs-12"> 
              <!-- Chart -->
              <canvas id="leadChart" width="500" height="400"></canvas>
             </div>  
             <div class="col-sm-12 col-xs-12"> 
              <!-- Status Filter Buttons -->
                <div class="mb-3" id="statusButtons" style="display: flex; flex-wrap: wrap; gap: 10px;">
                  <!-- JS will inject buttons here -->
                </div>
                
                <!-- Lead Table -->
                <h3 class="mt-4 mb-3">Lead List</h3>
                <div class="table-responsive">
                  <table class="table table-bordered table-striped table-responsive">
                    <thead class="table-dark">
                      <tr>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Status</th>
                        <!--<th>Assigned To</th>-->
                        <th>Created At</th>
                      </tr>
                    </thead>
                    <tbody id="leadListBody">
                      <!-- JS will populate this -->
                    </tbody>
                  </table>
                </div>
               </div>
             </div>
            </div>
          </div>
        </div>
      </div>       
  </section>
</div>

<!-- Scripts -->
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
let allLeads = [], chartRef;
let startDate = '', endDate = '';
let selectedStatus = 'all'; // Track selected status
let lastRangeType = '1m'; //  Default range

flatpickr("#customRange", {
    mode: "range",
    dateFormat: "Y-m-d",
    onChange: function(selectedDates) {
        if (selectedDates.length === 2) {
            startDate = selectedDates[0].toISOString().slice(0, 10);
            endDate = selectedDates[1].toISOString().slice(0, 10);
        }
    }
});

function renderChart(data) {
    const labels = Object.keys(data);
    const values = Object.values(data);

    if (chartRef) chartRef.destroy();

    const ctx = document.getElementById('leadChart').getContext('2d');
    chartRef = new Chart(ctx, {
        type: 'pie',
        data: {
            labels: labels,
            datasets: [{
                label: 'Leads by Status',
                data: values,
                backgroundColor: [
                    '#3498db', '#2ecc71', '#f1c40f', '#e67e22', '#e74c3c', '#9b59b6'
                ]
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'right'
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            const label = context.label || '';
                            const value = context.parsed || 0;
                            const total = context.dataset.data.reduce((a, b) => a + b, 0);
                            const percentage = ((value / total) * 100).toFixed(1);
                            return `${label}: ${value} (${percentage}%)`;
                        }
                    }
                },
                datalabels: {
                    color: '#fff',
                    formatter: (value, ctx) => {
                        return value; // hows count only (not percentage)
                    },
                    font: {
                        weight: 'bold',
                        size: 14
                    }
                }
            }
        },
        plugins: [ChartDataLabels] // register the datalabels plugin
    });

    // Status filter buttons
    let buttonsHtml = '';
    labels.forEach(status => {
        buttonsHtml += `<button class="btn btn-outline-secondary btn-sm" onclick="filterLeadsByStatus('${status}')">${status}</button>`;
    });
    $('#statusButtons').html(buttonsHtml);
}



function renderLeadTable(leads) {
    let rows = '';
    leads.forEach(lead => {
        rows += `<tr>
            <td>${lead.name}</td>
            <td>${lead.email}</td>
            <td>${lead.status}</td>
            <td>${lead.created_at}</td>
        </tr>`;
    });
    $('#leadListBody').html(rows);
}

function filterLeadsByStatus(status) {
    selectedStatus = status;
    $('#statusFilter').val(status); // 
    if (status === 'all') {
        renderLeadTable(allLeads);
    } else {
        const filtered = allLeads.filter(lead => lead.status === status);
        renderLeadTable(filtered);
    }
}

function applyFilters() {
    selectedStatus = $('#statusFilter').val();
    loadData(lastRangeType); // 
}

function loadData(rangeType) {
    lastRangeType = rangeType;
    const today = new Date();
    let start = '', end = '';

    switch(rangeType) {
        case '7d': start = new Date(today.setDate(today.getDate() - 6)); break;
        case '1m': start = new Date(today.setMonth(today.getMonth() - 1)); break;
        case '3m': start = new Date(today.setMonth(today.getMonth() - 3)); break;
        case '6m': start = new Date(today.setMonth(today.getMonth() - 6)); break;
        case '1y': start = new Date(today.setFullYear(today.getFullYear() - 1)); break;
        case 'custom':
            if (!startDate || !endDate) {
                alert("Please select a valid custom date range.");
                return;
            }
            start = startDate;
            end = endDate;
            break;
    }

    if (rangeType !== 'custom') {
        end = new Date();
        start = start.toISOString().slice(0, 10);
        end = end.toISOString().slice(0, 10);
    }

    $.ajax({
        url: '{{ route("leads.status.data") }}',
        data: { start: start, end: end, status: selectedStatus }, //  status
        success: function(res) {
            allLeads = res.leads;
            renderChart(res.chartData);
            renderLeadTable(allLeads);
        }
    });
}

$(document).ready(function () {
    loadData('1m');
});
</script>
@endsection
