@extends('adminlayout.dashadmin')

@section('content')

 <style>
    #userIdField {
      display: none;
      margin-top: 10px;
    }
  </style>
<div class="content-wrapper">
<section class="content">
 <div class="row profile-heading">

      <div class="col-sm-12 col-xs-12 contact">
        <div class="box box-info">
          <div class="box-header with-border text-center">
            <h3 class="box-title">Generate Lead</h3>
                <a class="btn btn-sm btn-dark" href="javascript:history.back()" style="float: inline-end;"> << Go Back</a>
          </div>
          
        @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif

           
                        <form method="post" class="form-horizontal" action="{{ route('save_lead') }}" enctype="multipart/form-data">
                            @csrf
						<div class="modal-body">
                            <div class="row">
                                
                                <div class="col-sm-4">
                                   
                                        <label for="name"  class="control-label">Name</label>
                                        
                                        <input type="text" name="name" id="name" class="form-control"  Placeholder="Enter Name" required>
                                        <span class="text-danger">@if ($errors->has('name')){{ $errors->first('name') }}@endif</span>
                                    
                                </div>
                                <div class="col-sm-4">
                                 
                                        <label for="email"  class="control-label">Email (optional)</label>
                                        <input type="text" name="email" id="email" class="form-control"  Placeholder="Enter email" >
                                        <span class="text-danger">@if ($errors->has('email')){{ $errors->first('email') }}@endif</span>
                                 
                                </div>
                                <div class="col-sm-4">
                                    
                                        <label for="phone" class="control-label">Phone</label>
                                        <input type="number" name="phone" id="phone" class="form-control"  Placeholder="Enter phone" required>
                                        <span class="text-danger">@if ($errors->has('phone')){{ $errors->first('phone') }}@endif</span>
                                    
                                </div>
                                
                                <div class="col-sm-4 ">               
                                <label for="date" class="control-label">
                                  <b> State </b>
                                </label>
                                <select id="supply_state" class="form-control" name="state" onchange="getCity(this.value)" required>
                                  <option value="">--Select--</option>
                                  @foreach($states as $state)
                                  <option value="{{$state->id}}">{{$state->name}}</option>
                                  @endforeach  
                        
                                </select>  
                              </div>
                              <div class="col-sm-4">               
                                <label for="date" class="control-label">
                                 <b> City </b>
                               </label>
                               <select id="city" class="form-control" name="city" required >
                        
                               </select>
                             </div> 
                              <div class="col-sm-4  mt-0">               
                                <label for="date" class="control-label">
                                 <b> Pin Code (optional)</b>
                               </label>
                               <input type="number" class="form-control" name="pin_code"  >
                        
                             </div> 
                             <div class="col-sm-4  mt-0">               
                                <label for="date" class="control-label">
                                 <b> Full Address (optional) </b>
                               </label>
                               <textarea type="text" class="form-control" name="full_address" size="5"></textarea>
                              
                               <input type="hidden" name="latitude" id="latitude" value="">
                               <input type="hidden" name="longitude" id="longitude" value="">
                        
                             </div> 
                               
                                <div class="col-sm-4">
                                     <label for="source" class="form-label">Lead Source</label>
                                      <select class="form-control" id="source" name="source" required onchange="toggleUserIdInput()">
                                        <option value="">Select Source</option>
                                        <option value="Facebook">Facebook</option>
                                        <option value="Google">Google</option>
                                        <option value="Website">Website</option>
                                        <option value="Referral">Referral</option>
                                        <option value="cold_calling">Cold Calling</option>
                                        <option value="marketing_visit">Marketing Visit</option>
                                        <option value="paper_activity">Paper Activity</option>
                                        <option value="joint_call">Joint Call</option>
                                        <option value="india_mart">India Mart</option>
                                        <option value="just_dail">Just Dial</option>
                                        <option value="trade_india">Trade India</option>
                                        <option value="instagram">Instagram</option>
                                        <option value="event_activity">Event Activity</option>
                                      </select>
                                      <div id="userIdField">
                                        <label for="user_id">Enter User ID for Joint Call:</label>
                                        <input type="text" id="user_id" name="user_id" placeholder="Enter Employee ID">
                                      </div>
                                      @error('user_id')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                                      <script>
                                        function toggleUserIdInput() {
                                          const activity = document.getElementById("source").value;
                                          const userIdField = document.getElementById("userIdField");
                                    
                                          if (activity === "joint_call") {
                                            userIdField.style.display = "block";
                                          } else {
                                            userIdField.style.display = "none";
                                            document.getElementById("user_id").value = ""; // Optional: clear input if hidden
                                          }
                                        }
                                      </script>
  
                                <span class="text-danger">@if ($errors->has('source')){{ $errors->first('source') }}@endif</span>
                                   
                                </div>
                                <div class="col-sm-4">
                                 <label for="product_interest" class="form-label">Product Interest</label>
                                  
                                  
                                  <select class="form-control" name="product_interest" required>
                                   <option value="">-- Select Business Type --</option>
                                  <option value="ev_scooty">Ev Scooty</option>
                                  <option value="battery">Battery</option>
                                  <option value="distributor">Distributor</option>
                                  <option value="dealer">Dealer</option>
                                  <option value="oem">OEM</option>
                                  <option value="skd">SKD</option>
                                  <option value="ckd">CKD</option>
                                  <option value="solar_panel">Solar Panel</option>
                                  </select>
                                </div>
                                <div class="col-sm-4">
                                    
                                <label for="Status" class="control-label">Status</label>
                                <select class="form-control" name="status" required>
                                  
                                <option value="New">New</option>
                                <option value="Interested">Interested</option>
                                <option value="NotInterested">Not Interested</option>
                                <option value="CallbackLater">Callback Later</option>
                                <option value="Converted">Converted</option>
                                <option value="Dropped">Dropped</option>
                                
                                </select>
                                <span class="text-danger">@if ($errors->has('note')){{ $errors->first('note') }}@endif</span>
                                   
                                </div> 
                               
                            </div>
                            <div class="row">
                                <hr>
                                <h3 class="box-title text-center" > Lead Followups  </h3>
                                 <div class="col-sm-4">
                                    <label for="Remarks" class="control-label">Followup Date </label>
                                    <input type="date" name="followup" class="form-control" required >
                                </div>
                                <div class="col-sm-4">
                                    <label for="Remarks" class="control-label">Next Followup(optional) </label>
                                    <input type="date" name="nextfollowup" class="form-control" >
                                </div>
                                <div class="col-sm-4">
                                    <label for="call status" class="control-label">Call Status </label>
                                    <select class="form-control" name="call_status" required>
                                        <option value="">-- Select Call Status --</option>
                                      <option value="Connected">Connected</option>
                                      <option value="Not Reachable">Not Reachable</option>
                                      <option value="Busy">Busy</option>
                                      <option value="No Answer">No Answer</option>
                                      <option value="Switched Off">Switched Off</option>
                                      <option value="Invalid Number">Invalid Number</option>
                                  </select>
                                    
                                </div>
                                 <div class="col-sm-12">
                                    
                                        <label for="Remarks" class="control-label">Remarks</label>
                                        <textarea name="notes" placeholder="Enter Remark" class="form-control" required></textarea>
                                        <span class="text-danger">@if ($errors->has('note')){{ $errors->first('note') }}@endif</span>
                                   
                                </div> 
                            </div>

                            </div>
							<div class="modal-footer" style="text-align: center;">
							  <button class="btn btn-lg btn-info" name="submit" data-loading-text="Processing...">
								<i class="fa fa-fw fa-save"></i>
								  Submit        </button>
							</div>
                        </form>
                    </div>
                </div>
            </div>       
   </section>
</div>
<script type="text/javascript">

  function partyHandler(val='')
  {
    var party_name = $('#party_name').val();
    var supply_state = $('#supply_state').val();
    var city = $('#city').val();
    
    //$('#reset').click();
    //$('#total').html('0');
    $('#party_name').val(party_name);
    $('#supply_state').val(supply_state);
    $('#city').val(city);
    
    if(val)
    {
      $("#vehiclelist :input").attr("disabled", false);
    }else{
      $("#vehiclelist :input").attr("disabled", true);

    }
  }
  partyHandler();
</script>  
<script >
  function getCity(state_id)
  {
   $.ajax({
    type: "GET",
    url: "{{url('city-list')}}/" + state_id,
    dataType: 'json',
    success: function(response) {
      console.log(response.cities);
      var option = '';
      if (response.status) {
       option += '<option value="" selected disabled> -- Select Option -- </option>';
       for (let index = 0; index < response.cities.length; index++) {
        option += "<option value='" + response.cities[index].id + "'>" + response.cities[index].name + "</option>";
      }
      $('#city').html(option);
    } else {
      $('#city').html(option);
    }
  }
});
 }
 </script>
 <style>
  /* Simple modal styles */
  #locationModal {
    display: none; /* Hidden by default */
    position: fixed;
    z-index: 10000; /* on top */
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    overflow: auto;
    background-color: rgba(0,0,0,0.5); /* Black with opacity */
  }
  #locationModalContent {
    background-color: #fff;
    margin: 15% auto; /* Centered */
    padding: 20px;
    border-radius: 8px;
    width: 300px;
    text-align: center;
  }
  #locationModal button {
    background-color: #007bff;
    color: white;
    border: none;
    padding: 10px 20px;
    border-radius: 5px;
    cursor: pointer;
  }
  #locationModal button:hover {
    background-color: #0056b3;
  }
</style>

<!-- Modal HTML -->
<div id="locationModal">
  <div id="locationModalContent">
    <p>Location permission is required to proceed.</p>
    <button id="retryLocationBtn">Enable Location</button>
  </div>
</div>

<script>
  document.addEventListener('DOMContentLoaded', function () {
      getLocation();

      const forms = document.querySelectorAll('form');
      forms.forEach(function(form) {
          form.addEventListener('submit', function(e) {
              const lat = document.getElementById('latitude').value;
              const lng = document.getElementById('longitude').value;

              if (!lat || !lng) {
                  e.preventDefault();
                  alert('Please enable location to proceed.');
              }
          });
      });

      // Retry button inside modal
      document.getElementById('retryLocationBtn').addEventListener('click', function() {
          hideModal();
          getLocation();
      });
  });

  function getLocation() {
      if (navigator.geolocation) {
          navigator.geolocation.getCurrentPosition(
              showPosition,
              showError,
              {
                  enableHighAccuracy: true,
                  timeout: 10000,
                  maximumAge: 0
              }
          );
      } else {
          alert("Geolocation is not supported by this browser.");
      }
  }

  function showPosition(position) {
      document.querySelectorAll('#latitude').forEach(input => {
          input.value = position.coords.latitude;
      });
      document.querySelectorAll('#longitude').forEach(input => {
          input.value = position.coords.longitude;
      });
      locationCaptured = true;
      hideModal();
  }

  function showError(error) {
      switch (error.code) {
          case error.PERMISSION_DENIED:
              // Show modal instead of alert
              showModal();
              break;
          case error.POSITION_UNAVAILABLE:
              alert("Location information is unavailable.");
              break;
          case error.TIMEOUT:
              alert("The request to get your location timed out.");
              break;
          case error.UNKNOWN_ERROR:
              alert("An unknown error occurred while fetching your location.");
              break;
      }
  }

  function showModal() {
      document.getElementById('locationModal').style.display = 'block';
  }
  function hideModal() {
      document.getElementById('locationModal').style.display = 'none';
  }
</script>


@endsection